<?php
/**
 * Theme Activation Tour
 *
 * This class handles the pointers used in the introduction tour.
 * @package Popup Demo
 *
 */

class WordImpress_Theme_Tour {

    private $pointer_close_id = 'wordimpress_tour'; //value can be cleared to retake tour

    /**
     * Class constructor.
     *
     * If user is on a pre pointer version bounce out.
     */
    function __construct() {
        global $wp_version;

        //pre 3.3 has no pointers
        if (version_compare($wp_version, '3.4', '<'))
            return false;

        //version is updated ::claps:: proceed
        add_action('admin_enqueue_scripts', array($this, 'enqueue'));
    }

    /**
     * Enqueue styles and scripts needed for the pointers.
     */
    function enqueue() {
        if (!current_user_can('manage_options'))
            return;

        // Assume pointer shouldn't be shown
        $enqueue_pointer_script_style = false;

        // Get array list of dismissed pointers for current user and convert it to array
        $dismissed_pointers = explode(',', get_user_meta(get_current_user_id(), 'dismissed_wp_pointers', true));

        // Check if our pointer is not among dismissed ones
        if (!in_array($this->pointer_close_id, $dismissed_pointers)) {
            $enqueue_pointer_script_style = true;

            // Add footer scripts using callback function
            add_action('admin_print_footer_scripts', array($this, 'intro_tour'));
        }

        // Enqueue pointer CSS and JS files, if needed
        if ($enqueue_pointer_script_style) {
            wp_enqueue_style('wp-pointer');
            wp_enqueue_script('wp-pointer');
        }

    }


    /**
     * Load the introduction tour
     */
    function intro_tour() {
	
	

       /* function cyb_activation_redirect( $plugin ) {
            if( $plugin == plugin_basename( '/wp-content/plugins/AKD-Framework' ) ) {
                exit( wp_redirect( admin_url( 'options-general.php?page=myplugin_settings' ) ) );
            }
        }
        add_action( 'activated_plugin', 'cyb_activation_redirect' ); */

        $adminpages = array(

            //array name is the unique ID of the screen @see: http://codex.wordpress.org/Function_Reference/get_current_screen
            'themes' => array(
                'content' => "<h3>" . __("Welcome to Hotsiko Elementor Version", 'textdomain') . "</h3>"
                    . "<p>" . __("You have just installed Hotsiko Elementor Theme. Congrats! Please take a moment to take the tour.", 'textdomain') . "</p>", //Content for this pointer
                'id' => 'menu-appearance', //ID of element where the pointer will point
                'position' => array(
                    'edge' => 'left', //Arrow position; change depending on where the element is located
                    'align' => 'center' //Alignment of Pointer
                ),
                'button2' => __('Next', 'textdomain'), //text for the next button
                'function' => 'window.location="' . admin_url('plugins.php?welcome_tour=1') . '";' //where to take the user
            ),
            'plugins' => array(
                'content' => '<h3>' . __('Install Plugins', 'textdomain') . '</h3><p>' . __('After activating the theme, click here to install all plugins required to run Hotsiko Theme successfully!', 'textdomain') . '</p>',
                'id' => 'setting-error-tgmpa',
                'position' => array(
                    'edge' => 'top', //Arrow position; change depending on where the element is located
                    'align' => 'left' //Alignment of Pointer
                ),

                'button2' => __('Next', 'textdomain'),
                'function' => 'window.location="' . admin_url('tools.php?welcome_tour=2') . '";'
            ),
            'tools'=> array(
                'content' => '<h3>' . __('License Key', 'textdomain') . '</h3><p>' . __('After activating the plugins through the link shown in previous step. 
                Enter the Hostiko License Key you bought and save it before registering the code. Once you regitered you can start using Hstiko Demo Themes through import/export tab on the page. Enjoy Hostiko Elementor theme!', 'textdomain') . '</p>',
                'id' => 'menu-tools',
                'position' => array(
                    'edge' => 'left', //Arrow position; change depending on where the element is located
                    'align' => 'center' //Alignment of Pointer
                ),



            ),
            /*'admin.php?page=Hostiko' => array(
                'content' => '<h3>' . __('License Number', 'textdomain') . '</h3><p>' . __('Kindly enter your product license key to activate your theme.', 'textdomain') . '</p>',
                'id' => 'menu-tools',
                'position' => array(
                    'edge' => 'left', //Arrow position; change depending on where the element is located
                    'align' => 'top' //Alignment of Pointer
                ),

                'button2' => __('Next', 'textdomain'),
                'function' => 'window.location="' . admin_url('admin.php?page=Hostikowelcome_tour=3') . '";'
            ),
            'admin' => array(
                'content' => '<h3>' . __('Save your License Key', 'textdomain') . '</h3><p>' . __('Save your license key first and then click on Regiser the code', 'textdomain') . '</p>',
                'id' => 'redux_save',
                'position' => array(
                    'edge' => 'top', //Arrow position; change depending on where the element is located
                    'align' => 'left' //Alignment of Pointer
                ),

                'button2' => __('Next', 'textdomain'),
                'function' => 'window.location="' . admin_url('admin.php?page=Hostikowelcome_tour=4') . '";'
            ),
            'admin' => array(
                'content' => '<h3>' . __('Available Layouts ', 'textdomain') . '</h3><p>' . __('By clicking on Import/Export you can check allthe avaialable layout options for your theme', 'textdomain') . '</p>',
                'id' => '1_section_group_li_a',
                'position' => array(
                    'edge' => 'left', //Arrow position; change depending on where the element is located
                    'align' => 'top' //Alignment of Pointer
                ),

                'button2' => __('Next', 'textdomain'),
                'function' => 'window.location="' . admin_url('admin.php?page=Hostikowelcome_tour=5') . '";'
            ),*/
            
        );

       

        $page = '';
        $screen = get_current_screen();


        //Check which page the user is on
        if (isset($_GET['page'])) {
            $page = $_GET['page'];
        }
        if (empty($page)) {
            $page = $screen->id;
        }

        $function = '';
        $button2 = '';
        $opt_arr = array();

        //Location the pointer points
        if (!empty($adminpages[$page]['id'])) {
            $id = '#' . $adminpages[$page]['id'];
        } else {
            $id = '#' . $screen->id;
        }


        //Options array for pointer used to send to JS
        
        if ('' != $page && in_array($page, array_keys($adminpages))) {
            $align = (is_rtl()) ? 'right' : 'left';
            $opt_arr = array(
                'content' => $adminpages[$page]['content'],
                'position' => array(
                    'edge' => (!empty($adminpages[$page]['position']['edge'])) ? $adminpages[$page]['position']['edge'] : 'left',
                    'align' => (!empty($adminpages[$page]['position']['align'])) ? $adminpages[$page]['position']['align'] : $align
                ),
                'pointerWidth' => 400
            );
            if (isset($adminpages[$page]['button2'])) {
                $button2 = (!empty($adminpages[$page]['button2'])) ? $adminpages[$page]['button2'] : __('Next', 'textdomain');
            }
            if (isset($adminpages[$page]['function'])) {
                $function = $adminpages[$page]['function'];
            }
        }
        $this->print_scripts($id, $opt_arr, __("Close", 'textdomain'), $button2, $function);
    }


    /**
     * Prints the pointer script
     *
     * @param string $selector The CSS selector the pointer is attached to.
     * @param array $options The options for the pointer.
     * @param string $button1 Text for button 1
     * @param string|bool $button2 Text for button 2 (or false to not show it, defaults to false)
     * @param string $button2_function The JavaScript function to attach to button 2
     * @param string $button1_function The JavaScript function to attach to button 1
     */
    function print_scripts($selector, $options, $button1, $button2 = false, $button2_function = '', $button1_function = '') {
        ?>
        <script type="text/javascript">
            //<![CDATA[
            (function ($) {

                var wordimpress_pointer_options = <?php echo json_encode( $options ); ?>, setup;

                //Userful info here
                wordimpress_pointer_options = $.extend(wordimpress_pointer_options, {
                    buttons: function (event, t) {
                        button = jQuery('<a id="pointer-close" style="margin-left:5px" class="button-secondary">' + '<?php echo $button1; ?>' + '</a>');
                        button.bind('click.pointer', function () {
                            t.element.pointer('close');
                        });
                        return button;
                    }
                });

                setup = function () {
                    $('<?php echo $selector; ?>').pointer(wordimpress_pointer_options).pointer('open');
                    <?php
                    if ( $button2 ) { ?>
                    jQuery('#pointer-close').after('<a id="pointer-primary" class="button-primary">' + '<?php echo $button2; ?>' + '</a>');
                    <?php } ?>
                    jQuery('#pointer-primary').click(function () {
                        <?php echo $button2_function; ?>
                    });
                    jQuery('#pointer-close').click(function () {
                        <?php if ( $button1_function == '' ) { ?>
                        $.post(ajaxurl, {
                            pointer: '<?php echo $this->pointer_close_id; ?>', // pointer ID
                            action: 'dismiss-wp-pointer'
                        });

                        <?php } else { ?>
                        <?php echo $button1_function; ?>
                        <?php } ?>
                    });

                };

                if (wordimpress_pointer_options.position && wordimpress_pointer_options.position.defer_loading) {
                    $(window).bind('load.wp-pointers', setup);
                } else {

                    $(document).ready(setup);
                }

            })(jQuery);
            //]]>
        </script>
    <?php
    }
}

$wordimpress_theme_tour = new WordImpress_Theme_Tour();

