<?php

namespace ElementPress\Modules\Sticky_Header\Modules\Transparent;

use Elementor;
use Elementor\Plugin;
use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use ElementPress\Modules\Sticky_Header\Base\Module_Base;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Module extends Module_Base
{

    public function __construct()
    {
        parent::__construct();

        $this->add_actions();
    }

    public function get_name()
    {
        return 'transparent';
    }

    public function register_controls(Controls_Stack $element)
    {
        $element->start_controls_section(
            'epress_sticky_header_effect',
            [
                'label' => __('ElementPress Sticky Header', 'elementpress'),
                'tab' => Controls_Manager::TAB_ADVANCED,
            ]
        );

        $element->add_control(
            'epress_transparent',
            [
                'label' => __('Enable', 'elementpress'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('On', 'elementpress'),
                'label_off' => __('Off', 'elementpress'),
                'return_value' => 'yes',
                'default' => '',
                'frontend_available' => true,
                'prefix_class' => 'sticky-header-'
            ]
        );

        $element->add_control(
            'epress_transparent_on',
            [
                'label' => __('Enable On', 'elementpress'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'label_block' => 'true',
                'default' => ['desktop', 'tablet', 'mobile'],
                'options' => [
                    'desktop' => __('Desktop', 'elementpress'),
                    'tablet' => __('Tablet', 'elementpress'),
                    'mobile' => __('Mobile', 'elementpress'),
                ],
                'condition' => [
                    'epress_transparent!' => ''
                ],
                'render_type' => 'none',
                'frontend_available' => true,
            ]
        );

        $element->add_responsive_control(
            'epress_scroll_distance',
            [
                'label' => __('Scroll Distance (px)', 'elementpress'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 60,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                ],
                'size_units' => ['px'],
                'description' => __('Choose the scroll distance to enable ElementPress Sticky Header ', 'elementpress'),
                'frontend_available' => true,
                'condition' => [
                    'epress_transparent!' => '',
                ]
            ]
        );

        $element->add_control(
            'epress_settings_notice',
            [
                'raw' => __('The settings below will not be applied until the page is scrolled to the scroll distance set above', 'elementpress'),
                'type' => Controls_Manager::RAW_HTML,
                'content_classes' => 'elementor-descriptor',
                'condition' => [
                    'epress_transparent!' => '',
                ],
            ]
        );

        $element->add_control(
            'epress_transparent_header_show',
            [
                'label' => __('Transparent Header', 'elementpress'),
                'type' => Controls_Manager::SWITCHER,
                'separator' => 'before',
                'label_on' => __('On', 'elementpress'),
                'label_off' => __('Off', 'elementpress'),
                'return_value' => 'yes',
                'default' => '',
                'frontend_available' => true,
                'condition' => [
                    'epress_transparent!' => '',
                ],
                'description' => __('Initial transparent header', 'elementpress'),
                'prefix_class' => 'sticky-header-transparent-'
            ]
        );
        $element->add_control(
            'epress_background_show',
            [
                'label' => __('Header Background', 'elementpress'),
                'type' => Controls_Manager::SWITCHER,
                'separator' => 'before',
                'label_on' => __('On', 'elementpress'),
                'label_off' => __('Off', 'elementpress'),
                'return_value' => 'yes',
                'default' => '',
                'frontend_available' => true,
                'condition' => [
                    'epress_transparent!' => '',
                ],
                'description' => __('Choose background color after scrolling', 'elementpress'),
            ]
        );

        $element->add_control(
            'epress_background',
            [
                'label' => __('Color', 'elementpress'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'epress_background_show' => 'yes',
                    'epress_transparent!' => '',
                ],
                'render_type' => 'none',
                'frontend_available' => true,
            ]
        );

        $element->add_control(
            'epress_bottom_border',
            [
                'label' => __('Bottom Border', 'elementpress'),
                'type' => Controls_Manager::SWITCHER,
                'separator' => 'before',
                'label_on' => __('On', 'elementpress'),
                'label_off' => __('Off', 'elementpress'),
                'return_value' => 'yes',
                'default' => '',
                'frontend_available' => true,
                'condition' => [
                    'epress_transparent!' => '',
                ],
                'description' => __('Choose bottom border size and color', 'elementpress'),
            ]
        );


        $element->add_control(
            'epress_custom_bottom_border_color',
            [
                'label' => __('Color', 'elementpress'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'epress_bottom_border' => 'yes',
                    'epress_transparent!' => '',
                ],
                'render_type' => 'none',
                'frontend_available' => true,
            ]
        );

        // $element->add_control(
        //     'epress_custom_bottom_border_width',
        //     [
        //         'label' => __('Width', 'elementpress'),
        //         'type' => Controls_Manager::SLIDER,
        //         'condition' => [
        //             'epress_bottom_border' => 'yes',
        //             'epress_transparent!' => '',
        //         ],
        //         'render_type' => 'none',
        //         'frontend_available' => true,
        //     ]
        // );

        $element->add_responsive_control(
            'epress_custom_bottom_border_width',
            [
                'label' => __('Width (px)', 'elementpress'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 0,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['px'],
                'condition' => [
                    'epress_bottom_border' => 'yes',
                    'epress_transparent!' => '',
                ],
                'frontend_available' => true,
            ]
        );

        $element->add_control(
            'epress_shrink_header',
            [
                'label' => __('Shrink', 'elementpress'),
                'type' => Controls_Manager::SWITCHER,
                'separator' => 'before',
                'label_on' => __('On', 'elementpress'),
                'label_off' => __('Off', 'elementpress'),
                'return_value' => 'yes',
                'default' => '',
                'frontend_available' => true,
                'description' => __('Choose header height after scrolling', 'elementpress'),
                'condition' => [
                    'epress_transparent!' => '',
                ],
            ]
        );

        $element->add_responsive_control(
            'epress_custom_height_header',
            [
                'label' => __('Height (px)', 'elementpress'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 70,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                ],
                'size_units' => ['px'],
                'condition' => [
                    'epress_shrink_header' => 'yes',
                    'epress_transparent!' => '',
                ],
                'frontend_available' => true,
            ]
        );

        $element->add_control(
            'epress_shrink_header_logo',
            [
                'label' => __('Logo', 'elementpress'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('On', 'elementpress'),
                'label_off' => __('Off', 'elementpress'),
                'return_value' => 'yes',
                'default' => '',
                'frontend_available' => true,
                'description' => __('Choose logo height after scrolling', 'elementpress'),
                'condition' => [
                    'epress_shrink_header' => 'yes',
                    'epress_transparent!' => '',
                ],
            ]
        );

        $element->add_responsive_control(
            'epress_custom_height_header_logo',
            [
                'label' => __('Height (px)', 'elementpress'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => '',
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                ],
                'size_units' => ['px'],
                'condition' => [
                    'epress_shrink_header_logo' => 'yes',
                    'epress_transparent!' => '',
                ],
                'frontend_available' => true,
            ]
        );


        $element->end_controls_section();
    }

    private function add_actions()
    {
        if (!function_exists('is_plugin_active')) {

            include_once(ABSPATH . 'wp-admin/includes/plugin.php');
        }

        if (is_plugin_active('elementor-pro/elementor-pro.php')) {
            add_action('elementor/element/section/section_effects/after_section_end', [$this, 'register_controls']);
        } else {
            add_action('elementor/element/section/section_advanced/after_section_end', [$this, 'register_controls']);
        }

        add_action('elementor/frontend/after_enqueue_styles', [$this, 'enqueue_styles']);
        if (Elementor\Plugin::instance()->editor->is_edit_mode()) {
        } else {
            add_action('wp_enqueue_scripts', [$this, 'enqueue_scripts']);
        }
    }

    public function enqueue_styles()
    {
        $suffix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

        wp_enqueue_style(
            'sticky-header-style',
            Sticky_Header_Assets_Url . 'css/sticky-header-style' . '.css',
            [],
            \ElementPress::version
        );
    }

    public function enqueue_scripts()
    {
        $suffix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

        wp_enqueue_script(
            'sticky-header',
            Sticky_Header_Url . 'assets/js/sticky-header.js',
            [
                'jquery',
            ],
            \ElementPress::version,
            false
        );
    }
}
