<?php
namespace ElementPress\Modules\Library;
defined( 'ABSPATH' ) || exit;
class Init{
    private $dir;
    private $url;
    public function __construct(){
        // get current directory path.
        $this->dir = dirname(__FILE__) . '/';
        // get current module's url.
        $this->url = \ElementPress::plugin_url() . 'modules/library/';
        // enqueue editor js for elementor.
        add_action( 'elementor/editor/before_enqueue_scripts', array( $this, 'editor_scripts' ),10);
        // print views and tab variables on footer.
        add_action( 'elementor/editor/footer', array($this, 'admin_inline_js') );
        add_action( 'elementor/editor/footer', array( $this, 'print_views' ) );
        // enqueue editor css.
        add_action( 'elementor/editor/after_enqueue_styles', array( $this, 'editor_styles' ) );
        // enqueue modal's preview css.
        add_action( 'elementor/preview/enqueue_styles', array( $this, 'preview_styles' ) );
        // call api manager.
        new Manager\Api();
    }
    public function editor_scripts(){
		wp_enqueue_script( 
			'elementpress-library-editor-script', 
			$this->url . 'assets/js/editor.js', 
			array('jquery', 'underscore', 'backbone-marionette'), 
			\ElementPress::version,
			true
		);
	}
	public function editor_styles(){
		wp_enqueue_style( 'elementpress-library-editor-style', $this->url . 'assets/css/editor.css', array(), \ElementPress::version);
	}
	public function preview_styles(){
		wp_enqueue_style( 'elementpress-library-preview-style', $this->url . 'assets/css/preview.css', array(), \ElementPress::version );
	}
	public function admin_inline_js() { ?>
		<script type="text/javascript" >
		var ElementorOptLibreryData = {
			"libraryButton": "Elements Button",
			"modalRegions": {
				"modalHeader": ".dialog-header",
				"modalContent": ".dialog-message"
			},
			"license": {
				"activated": true,
				"link": ""
			},
			"tabs": {
				 "elementpress_page": {
					"title": "Ready Pages",
					"data": [],
					"sources": ["elementpress-theme", "elementpress-api"],
					"settings": {
						"show_title": true,
						"show_keywords": true
					}
				}, 
				"elementpress_header": {
					"title": "Headers",
					"data": [],
					"sources": ["elementpress-theme", "elementpress-api"],
					"settings": {
						"show_title": false,
						"show_keywords": true
					}
				},
				"elementpress_footer": {
					"title": "Footers",
					"data": [],
					"sources": ["elementpress-theme", "elementpress-api"],
					"settings": {
						"show_title": false,
						"show_keywords": true
					}
				},
				 "elementpress_section": {
					"title": "Sections",
					"data": [],
					"sources": ["elementpress-theme", "elementpress-api"],
					"settings": {
						"show_title": false,
						"show_keywords": true
					}
				},
				"elementpress_single": {
					"title": "Single",
					"data": [],
					"sources": ["elementpress-theme", "elementpress-api"],
					"settings": {
						"show_title": false,
						"show_keywords": true
					}
				},
				"elementpress_archive": {
					"title": "Archive",
					"data": [],
					"sources": ["elementpress-theme", "elementpress-api"],
					"settings": {
						"show_title": false,
						"show_keywords": true
					}
				},
				"elementpress_notfound": {
					"title": "404",
					"data": [],
					"sources": ["elementpress-theme", "elementpress-api"],
					"settings": {
						"show_title": false,
						"show_keywords": true
					}
				},
				"elementpress_maintenance": {
					"title": "Coming Soon",
					"data": [],
					"sources": ["elementpress-theme", "elementpress-api"],
					"settings": {
						"show_title": false,
						"show_keywords": true
					}
				},
				"elementpress_search": {
					"title": "Search",
					"data": [],
					"sources": ["elementpress-theme", "elementpress-api"],
					"settings": {
						"show_title": false,
						"show_keywords": true
					}
				},
				"elementpress_blog": {
					"title": "Blogs",
					"data": [],
					"sources": ["elementpress-theme", "elementpress-api"],
					"settings": {
						"show_title": false,
						"show_keywords": true
					}
				},
				"elementpress_mega_menu": {
					"title": "Mega Menu",
					"data": [],
					"sources": ["elementpress-theme", "elementpress-api"],
					"settings": {
						"show_title": false,
						"show_keywords": true
					}
				}, 
				/*"elementpress_widget": {
					"title": "Widget Presets",
					"data": [],
					"sources": ["elementpress-theme", "elementpress-api"],
					"settings": {
						"show_title": false,
						"show_keywords": true
					}
				},*/
				// "local": {
				// 	"title": "My Library",
				// 	"data": [],
				// 	"sources": ["elementpress-local"],
				// 	"settings": []
				// }
			},
			"defaultTab": "elementpress_header"
		};
		</script> <?php
	}
	public function print_views(){
		foreach ( glob( $this->dir . 'views/editor/*.php' ) as $file ) {
			$name = basename( $file, '.php' );
			ob_start();
			include $file;
			printf( '<script type="text/html" id="view-elementpress-%1$s">%2$s</script>', $name, ob_get_clean() );
		}
	}
}