<?php
namespace ElementPress;

defined( 'ABSPATH' ) || exit; //exit if call directly.

class Notice {
	private static $_instance = null;	
    public static function instance() { //create one instance of class (singleton)

        if ( is_null( self::$_instance ) ) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }
        public static function sendParams($notice) {

		$args = [
			'type'             => 'info',
			'message'          => '',
			'class'            => 'epress-notice',
			'dismissible'      => false,
			'btn'			   => [],
		];
		$notice = wp_parse_args( $notice, $args ); //Merge user defined arguments into defaults array.
		$classes = [ 'notice' ]; //classes used for display message
		$classes[] = $notice['class'];
		if ( isset( $notice['type'] ) ) {
			$classes[] = 'notice-' . $notice['type'];
		}
		$notice['classes'] = implode( ' ', $classes ); //seperate class by space
		self::displayNotice($notice); //display notice message		
	}
	public static function displayNotice( $notice = [] ) {
		?>

		<div class="<?php echo esc_attr( $notice['classes'] ); ?>">
				<div class="epress-logo">
					<img src="<?php echo esc_url( \ElementPress::admin_url() . 'assets/images/elementor-logo.png' ); ?>" alt="epress Logo" />
				</div>

				<div class="epress-notice-content">
					<h3><?php esc_html_e( 'Thanks for installing ElementPress!', 'elementpress' ); ?></h3>
					<p>
					<p>ElementPress is an ultimate plugin with inclusive features designed to work with Elementor Page Builder.</p>
					<a href="https://elementor.com/" target="_blank"><?php esc_html_e( 'What is Elementor?', 'elementpress' ); ?></a>
					</p>
				</div>

				<div class="epress-btn">
					<a class="button button-primary" href="<?php echo esc_url($notice['btn']['url']); ?>"><i class="dashicons dashicons-download"></i><?php echo esc_html($notice['btn']['label']); ?></a>
				</div>
			</div>
		</div>
		<?php
	}
}
Notice::instance();