<?php

namespace Elementor;
use \Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit;

class Elementpress_Widget_searchpost extends Widget_Base {

	public $base;

    public function get_name() {

		return 'elementpress-searchpost';

    }

    public function get_title() {

        return esc_html__( 'Search Post', 'elementpress' );

    }

    public function get_icon() {

		return 'eicon-site-search';

    }

    public function get_categories() {

		return [ 'elementpress_singlepost' ];

    }

    protected function register_controls() {

		$this->content_layout_options();

		$this->style_layout_options();

		$this->style_box_options();

		$this->style_image_options();

		$this->style_title_options();

		$this->style_not_found_options();

		$this->style_meta_options();

		$this->style_content_options();

		$this->style_readmore_options();

		 }

		 private function content_layout_options() {

			$this->start_controls_section(

				'section_layout',

				[

					'label' => esc_html__( 'Layout', 'elementpress' ),

				]

			);

			$this->add_control(

				'elementpressd_grid_style',

				[

					'label' => __( 'Grid Style', 'elementpress' ),

					'type' => Controls_Manager::SELECT,

					'default' => '1',

					'options' => [

						'1' => esc_html__( 'Layout 1', 'elementpress' ),

						'2' => esc_html__( 'Layout 2', 'elementpress' ),

						'3' => esc_html__( 'Layout 3', 'elementpress' ),

						'4' => esc_html__( 'Layout 4', 'elementpress' ),

						'5' => esc_html__( 'Layout 5', 'elementpress' ),

					],

				]

			);

			$this->add_responsive_control(

				'elementpressd_columns',

				[

					'label' => __( 'Columns', 'elementpress' ),

					'type' => Controls_Manager::SELECT,

					'default' => '3',

					'tablet_default' => '2',

					'mobile_default' => '1',

					'options' => [

						'1' => '1',

						'2' => '2',

						'3' => '3',

						'4' => '4',

					],

					'prefix_class' => 'elementor-grid%s-',

					'frontend_available' => true,

					'selectors' => [

						' {{WRAPPER}} elementor-portfolio-item' => 'width: calc( 100% / {{SIZE}} )',

					],

				]

			);

			$this->add_control(

				'elementpressd_show_image',

				[

					'label' => __( 'Image', 'elementpress' ),

					'type' => Controls_Manager::SWITCHER,

					'label_on' => __( 'Show', 'elementpress' ),

					'label_off' => __( 'Hide', 'elementpress' ),

					'default' => 'yes',

					'separator' => 'before',

				]

			);

			$this->add_group_control(

				\Elementor\Group_Control_Image_Size::get_type(),

				[

					'name' => 'post_thumbnail',

					'exclude' => [ 'custom' ],

					'default' => 'full',

					'prefix_class' => 'post-thumbnail-size-',

					'condition' => [

						'elementpressd_show_image' => 'yes',

					],

				]

			);

			$this->add_control(

				'elementpressd_show_title',

				[

					'label' => __( 'Title', 'elementpress' ),

					'type' => Controls_Manager::SWITCHER,

					'label_on' => __( 'Show', 'elementpress' ),

					'label_off' => __( 'Hide', 'elementpress' ),

					'default' => 'yes',

					'separator' => 'before',

				]

			);

			$this->add_control(

				'elementpressd_title_tag',

				[

					'label' => __( 'Title HTML Tag', 'elementpress' ),

					'type' => Controls_Manager::SELECT,

					'options' => [

						'h1' => 'H1',

						'h2' => 'H2',

						'h3' => 'H3',

						'h4' => 'H4',

						'h5' => 'H5',

						'h6' => 'H6',

						'div' => 'div',

						'span' => 'span',

						'p' => 'p',

					],

					'default' => 'h3',

					'condition' => [

						'elementpressd_show_title' => 'yes',

					],

				]

			);

			$this->add_control(

				'elementpressd_meta_data',

				[

					'label' => __( 'Meta Data', 'elementpress' ),

					'label_block' => true,

					'type' => Controls_Manager::SELECT2,

					'default' => [ 'date', 'comments' ],

					'multiple' => true,

					'options' => [

						'author' => __( 'Author', 'elementpress' ),

						'date' => __( 'Date', 'elementpress' ),

						'categories' => __( 'Categories', 'elementpress' ),

						'comments' => __( 'Comments', 'elementpress' ),

						'tags' => __( 'Tags', 'elementpress' ),

					],

					'separator' => 'before',

				]

			);

			$this->add_control(

				'meta_separator',

				[

					'label' => __( 'Separator Between', 'elementpress' ),

					'type' => Controls_Manager::TEXT,

					'default' => '/',

					'selectors' => [

						'{{WRAPPER}} .elementpress-grid-container .elementpress-post .elementpress-post-grid-meta span + span:before' => 'content: "{{VALUE}}"',

					],

					'condition' => [

						'meta_data!' => [],

					],

				]

			);

			$this->add_control(

				'elementpressd_show_excerpt',

				[

					'label' => __( 'Excerpt', 'elementpress' ),

					'type' => Controls_Manager::SWITCHER,

					'label_on' => __( 'Show', 'elementpress' ),

					'label_off' => __( 'Hide', 'elementpress' ),

					'default' => 'yes',

					'separator' => 'before',

				]

			);

			$this->add_control(

				'elementpressd_excerpt_length',

				[

					'label' => __( 'Excerpt Length', 'elementpress' ),

					'type' => Controls_Manager::NUMBER,

					/** This filter is documented in wp-includes/formatting.php */

					'default' => apply_filters( 'excerpt_length', 25 ),

					'condition' => [

						'elementpressd_show_excerpt' => 'yes',

					],

				]

			);

			$this->add_control(

				'elementpressd_show_read_more',

				[

					'label' => __( 'Read More', 'elementpress' ),

					'type' => Controls_Manager::SWITCHER,

					'label_on' => __( 'Show', 'elementpress' ),

					'label_off' => __( 'Hide', 'elementpress' ),

					'default' => 'yes',

					'separator' => 'before',

				]

			);

			$this->add_control(

				'elementpressd_read_more_text',

				[

					'label' => __( 'Read More Text', 'elementpress' ),

					'type' => Controls_Manager::TEXT,

					'default' => __( 'Read More »', 'elementpress' ),

					'condition' => [

						'elementpressd_show_read_more' => 'yes',

					],

				]

			);

			$this->add_control(

				'elementpressd_content_align',

				[

					'label' => __( 'Alignment', 'elementpress' ),

					'type' => Controls_Manager::CHOOSE,

					'options' => [

						'left' => [

							'title' => __( 'Left', 'elementpress' ),

							'icon' => 'fa fa-align-left',

						],

						'center' => [

							'title' => __( 'Center', 'elementpress' ),

							'icon' => 'fa fa-align-center',

						],

						'right' => [

							'title' => __( 'Right', 'elementpress' ),

							'icon' => 'fa fa-align-right',

						],

					],

					'default' => 'left',

					'selectors' => [

						'{{WRAPPER}} .elementpress-post-grid-inner' => 'text-align: {{VALUE}};',

					],

					'separator' => 'before',

				]

			);

			$this->end_controls_section();

		 }

		private function style_layout_options() {

			// Layout.

			$this->start_controls_section(

				'section_layout_style',

				[

					'label' => __( 'Layout', 'elementpress' ),

					'tab'   => Controls_Manager::TAB_STYLE,

				]

			);

			// Columns margin.

			$this->add_control(

				'elementpressd_grid_style_columns_margin',

				[

					'label'     => __( 'Columns margin', 'elementpress' ),

					'type'      => Controls_Manager::SLIDER,

					'default'   => [

						'size' => 15,

					],

					'range'     => [

						'px' => [

							'min' => 0,

							'max' => 100,

						],

					],

					'selectors' => [

						'{{WRAPPER}} .elementpress-grid-container' => 'grid-column-gap: {{SIZE}}{{UNIT}}',

					],

				]

			);

			// Row margin.

			$this->add_control(

				'elementpressd_grid_style_rows_margin',

				[

					'label'     => __( 'Rows margin', 'elementpress' ),

					'type'      => Controls_Manager::SLIDER,

					'default'   => [

						'size' => 30,

					],

					'range'     => [

						'px' => [

							'min' => 0,

							'max' => 100,

						],

					],

					'selectors' => [

						'{{WRAPPER}} .elementpress-grid-container' => 'grid-row-gap: {{SIZE}}{{UNIT}}',

					],

				]

			);

			$this->end_controls_section();

		}

		private function style_box_options() {

			// Box.

			$this->start_controls_section(

				'section_box',

				[

					'label' => __( 'Box', 'elementpress' ),

					'tab' => Controls_Manager::TAB_STYLE,

				]

			);

	// Box internal margin.

	$this->add_responsive_control(

		'elementpressd_grid_items_style_margin',

		[

			'label'      => __( 'Margin', 'elementpress' ),

			'type'       => Controls_Manager::DIMENSIONS,

			'size_units' => [ 'px', '%' ],

			'selectors'  => [

				'{{WRAPPER}} .elementpress-grid-container .elementpress-post' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',

			],

		]

	);

			// Box internal padding.

			$this->add_responsive_control(

				'elementpressd_grid_items_style_padding',

				[

					'label'      => __( 'Padding', 'elementpress' ),

					'type'       => Controls_Manager::DIMENSIONS,

					'size_units' => [ 'px', '%' ],

					'selectors'  => [

						'{{WRAPPER}} .elementpress-grid-container .elementpress-post' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',

					],

				]

			);

			$this->start_controls_tabs( 'grid_button_style' );

			// Normal tab.

			$this->start_controls_tab(

				'elementpressd_grid_button_style_normal',

				[

					'label'     => __( 'Normal', 'elementpress' ),

				]

			);

	// Image border radius.

	$this->add_control(

		'elementpressd_grid_box_border_width',

		[

			'label'      => __( 'Border width', 'elementpress' ),

			'type'       => Controls_Manager::DIMENSIONS,

			'size_units' => [ 'px', '%' ],

			'selectors'  => [

				'{{WRAPPER}}  .elementpress-grid-container .elementpress-post' => 'border-style: solid; border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',

			],				

		]

	);

	// Border Radius.

	$this->add_control(

		'elementpressd_grid_style_border_radius',

		[

			'label'     => __( 'Border Radius', 'elementpress' ),

			'type'      => Controls_Manager::SLIDER,

			'default'   => [

				'size' => 0,

			],

			'range'     => [

				'px' => [

					'min' => 0,

					'max' => 200,

				],

			],

			'selectors' => [

				'{{WRAPPER}} .elementpress-grid-container .elementpress-post' => 'border-radius: {{SIZE}}{{UNIT}}',

			],

		]

	);

			// Normal background color.

			$this->add_control(

				'elementpressd_grid_button_style_normal_bg_color',

				[

					'type'      => Controls_Manager::COLOR,

					'label'     => __( 'Background Color', 'elementpress' ),

					'scheme'    => [

						'type'  => \Elementor\Core\Schemes\Color::get_type(),

						'value' => \Elementor\Core\Schemes\Color::COLOR_1,

					],

					'separator' => '',

					'selectors' => [

						'{{WRAPPER}} .elementpress-grid-container .elementpress-post' => 'background-color: {{VALUE}};',

					],

				]

			);

			// Normal border color.

			$this->add_control(

				'elementpressd_grid_button_style_normal_border_color',

				[

					'type'      => Controls_Manager::COLOR,

					'label'     => __( 'Border Color', 'elementpress' ),

					'scheme'    => [

						'type'  => \Elementor\Core\Schemes\Color::get_type(),

						'value' => \Elementor\Core\Schemes\Color::COLOR_1,

					],

					'separator' => '',

					'selectors' => [

						'{{WRAPPER}} .elementpress-grid-container .elementpress-post' => 'border-color: {{VALUE}};',

					],

				]

			);

			// Normal box shadow.

			$this->add_group_control(

				\Elementor\Group_Control_Box_Shadow::get_type(),

				[

					'name'      => 'elementpressd_grid_button_style_normal_box_shadow',

					'selector'  => '{{WRAPPER}} .elementpress-grid-container .elementpress-post',

				]

			);

			$this->end_controls_tab();

			// Hover tab.

			$this->start_controls_tab(

				'elementpressd_grid_button_style_hover',

				[

					'label'     => __( 'Hover', 'elementpress' ),

				]

			);

	// Image border radius.

			$this->add_control(

				'elementpressd_grid_box_border_width_hover',

				[

					'label'      => __( 'Border width', 'elementpress' ),

					'type'       => Controls_Manager::DIMENSIONS,

					'size_units' => [ 'px', '%' ],

					'selectors'  => [

						'{{WRAPPER}}  .elementpress-grid-container .elementpress-post:hover' => 'border-style: solid; border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',

					],				

				]

			);

			// Border Radius.

			$this->add_control(

				'elementpressd_grid_style_border_radius_hover',

				[

					'label'     => __( 'Border Radius', 'elementpress' ),

					'type'      => Controls_Manager::SLIDER,

					'default'   => [

						'size' => 0,

					],

					'range'     => [

						'px' => [

							'min' => 0,

							'max' => 200,

						],

					],

					'selectors' => [

						'{{WRAPPER}} .elementpress-grid-container .elementpress-post:hover' => 'border-radius: {{SIZE}}{{UNIT}}',

					],

				]

			);

			// Hover background color.

			$this->add_control(

				'elementpressd_grid_button_style_hover_bg_color',

				[

					'type'      => Controls_Manager::COLOR,

					'label'     => __( 'Background Color', 'elementpress' ),

					'scheme'    => [

						'type'  => \Elementor\Core\Schemes\Color::get_type(),

						'value' => \Elementor\Core\Schemes\Color::COLOR_1,

					],

					'separator' => '',

					'selectors' => [

						'{{WRAPPER}} .elementpress-grid-container .elementpress-post:hover' => 'background-color: {{VALUE}};',

					],

				]

			);

			// Hover border color.

			$this->add_control(

				'elementpressd_grid_button_style_hover_border_color',

				[

					'type'      => Controls_Manager::COLOR,

					'label'     => __( 'Border Color', 'elementpress' ),

					'scheme'    => [

						'type'  => \Elementor\Core\Schemes\Color::get_type(),

						'value' => \Elementor\Core\Schemes\Color::COLOR_1,

					],

					'separator' => '',

					'selectors' => [

						'{{WRAPPER}} .elementpress-grid-container .elementpress-post:hover' => 'border-color: {{VALUE}};',

					],

				]

			);

			// Hover box shadow.

			$this->add_group_control(

				\Elementor\Group_Control_Box_Shadow::get_type(),

				[

					'name'      => 'elementpressd_grid_button_style_hover_box_shadow',

					'selector'  => '{{WRAPPER}} .elementpress-grid-container .elementpress-post',

				]

			);

			$this->end_controls_tab();

			$this->end_controls_tabs();

			$this->end_controls_section();

		}

	private function style_image_options() {

			// Box.

			$this->start_controls_section(

				'section_image',

				[

					'label' => __( 'Image', 'elementpress' ),

					'tab' => Controls_Manager::TAB_STYLE,

				]

			);

			// Image border radius.

			$this->add_control(

				'elementpressd_grid_image_border_radius',

				[

					'label'      => __( 'Border Radius', 'elementpress' ),

					'type'       => Controls_Manager::DIMENSIONS,

					'size_units' => [ 'px', '%' ],

					'selectors' => [

						'{{WRAPPER}} .elementpress-post-grid-inner .elementpress-post-grid-thumbnail img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

					],

				]

			);

			$this->add_responsive_control(

				'elementpressd_elementpressd_grid_style_image_margin',

				[

					'label'      => __( 'Margin', 'elementpress' ),

					'type'       => Controls_Manager::DIMENSIONS,

					'size_units' => [ 'px' ],

					'selectors'  => [

						'{{WRAPPER}} .elementpress-post-grid-inner .elementpress-post-grid-thumbnail' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

					],

				]

			);

			$this->add_responsive_control(

				'elementpressd_elementpressd_grid_style_image_padding',

				[

					'label'      => __( 'Padding', 'elementpress' ),

					'type'       => Controls_Manager::DIMENSIONS,

					'size_units' => [ 'px' ],

					'selectors'  => [

						'{{WRAPPER}} .elementpress-post-grid-inner .elementpress-post-grid-thumbnail' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

					],

				]

			);

			$this->end_controls_section();

		}

	private function style_title_options() {

			// Tab.

			$this->start_controls_section(

				'section_grid_title_style',

				[

					'label'     => __( 'Title', 'elementpress' ),

					'tab'       => Controls_Manager::TAB_STYLE,

				]

			);

			// Title typography.

			$this->add_group_control(

				\Elementor\Group_Control_Typography::get_type(),

				[

					'name'     => 'elementpressd_grid_title_style_typography',

					'scheme'   => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,

					'selector' => '{{WRAPPER}} .elementpress-grid-container .elementpress-post .title,{{WRAPPER}} .elementpress-grid-container .elementpress-post .title > a'

				]

			);

			// Title color.

			$this->add_control(

				'elementpressd_grid_title_style_color',

				[

					'type'      => Controls_Manager::COLOR,

					'label'     => __( 'Color', 'elementpress' ),

					'scheme'    => [

						'type'  => \Elementor\Core\Schemes\Color::get_type(),

						'value' => \Elementor\Core\Schemes\Color::COLOR_1,

					],				

					'selectors' => [

						'{{WRAPPER}} .elementpress-grid-container .elementpress-post .title, {{WRAPPER}} .elementpress-grid-container .elementpress-post .title > a'=> 'color: {{VALUE}};',					

					],

				]

			);

	// Title color hover.

	$this->add_control(

		'elementpressd_grid_title_style_colorhover',

		[

			'type'      => Controls_Manager::COLOR,

			'label'     => __( 'Hover Color', 'elementpress' ),

			'scheme'    => [

				'type'  => \Elementor\Core\Schemes\Color::get_type(),

				'value' => \Elementor\Core\Schemes\Color::COLOR_1,

			],				

			'selectors' => [

				'{{WRAPPER}} .elementpress-grid-container .elementpress-post .title:hover, {{WRAPPER}} .elementpress-grid-container .elementpress-post .title > a:hover'=> 'color: {{VALUE}};',					

			],

		]

	);

			// Title margin.

			$this->add_responsive_control(

				'elementpressd_grid_title_style_margin',

				[

					'label'      => __( 'Margin', 'elementpress' ),

					'type'       => Controls_Manager::DIMENSIONS,

					'size_units' => [ 'px' ],

					'selectors'  => [

						'{{WRAPPER}} .elementpress-grid-container .elementpress-post .title,{{WRAPPER}} .elementpress-grid-container .elementpress-post .title>a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

					],

				]

			);

			$this->end_controls_section();

		}

		private function style_meta_options() {

			// Tab.

			$this->start_controls_section(

				'section_grid_meta_style',

				[

					'label'     => __( 'Meta', 'elementpress' ),

					'tab'       => Controls_Manager::TAB_STYLE,

				]

			);

			// Meta typography.

			$this->add_group_control(

				\Elementor\Group_Control_Typography::get_type(),

				[

					'name'     => 'elementpressd_grid_meta_style_typography',

					'scheme'   => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,

					'selector' => '{{WRAPPER}} .elementpress-grid-container .elementpress-post .elementpress-post-grid-meta span',

				]

			);

			// Meta color.

			$this->add_control(

				'elementpressd_grid_meta_style_color',

				[

					'type'      => Controls_Manager::COLOR,

					'label'     => __( 'Color', 'elementpress' ),

					'scheme'    => [

						'type'  => \Elementor\Core\Schemes\Color::get_type(),

						'value' => \Elementor\Core\Schemes\Color::COLOR_1,

					],

					'selectors' => [

						'{{WRAPPER}} .elementpress-grid-container .elementpress-post .elementpress-post-grid-meta span'  => 'color: {{VALUE}};',

						'{{WRAPPER}} .elementpress-grid-container .elementpress-post .elementpress-post-grid-meta span a' => 'color: {{VALUE}};',

					],

				]

			);

			$this->add_control(

				'elementpressd_grid_meta_style_colorhover',

				[

					'type'      => Controls_Manager::COLOR,

					'label'     => __( 'Hover Color', 'elementpress' ),

					'scheme'    => [

						'type'  => \Elementor\Core\Schemes\Color::get_type(),

						'value' => \Elementor\Core\Schemes\Color::COLOR_1,

					],

					'selectors' => [

						'{{WRAPPER}} .elementpress-grid-container .elementpress-post .elementpress-post-grid-meta span:hover'  => 'color: {{VALUE}};',

						'{{WRAPPER}} .elementpress-grid-container .elementpress-post .elementpress-post-grid-meta span a:hover' => 'color: {{VALUE}};',

					],

				]

			);

			// Meta margin.

			$this->add_responsive_control(

				'elementpressd_grid_meta_style_margin',

				[

					'label'      => __( 'Margin', 'elementpress' ),

					'type'       => Controls_Manager::DIMENSIONS,

					'size_units' => [ 'px' ],

					'selectors'  => [

						'{{WRAPPER}} .elementpress-grid-container .elementpress-post .elementpress-post-grid-meta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

					],

				]

			);

			$this->end_controls_section();

		}

		private function style_content_options() {

			// Tab.

			$this->start_controls_section(

				'section_grid_content_style',

				[

					'label' => __( 'Content', 'elementpress' ),

					'tab'   => Controls_Manager::TAB_STYLE,

				]

			);

			// Content typography.

			$this->add_group_control(

				\Elementor\Group_Control_Typography::get_type(),

				[

					'name'      => 'elementpressd_grid_content_style_typography',

					'scheme'    => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,

					'selector'  => '{{WRAPPER}} .elementpress-grid-container .elementpress-post .elementpress-post-grid-excerpt ',

				]

			);

			// Content color.

			$this->add_control(

				'elementpressd_grid_content_style_color',

				[

					'type'      => Controls_Manager::COLOR,

					'label'     => __( 'Color', 'elementpress' ),

					'scheme'    => [

						'type'  => \Elementor\Core\Schemes\Color::get_type(),

						'value' => \Elementor\Core\Schemes\Color::COLOR_1,

					],

					'selectors' => [

						'{{WRAPPER}} .elementpress-grid-container .elementpress-post .elementpress-post-grid-excerpt ' => 'color: {{VALUE}};',

					],

				]

			);

			// Content margin

			$this->add_responsive_control(

				'elementpressd_grid_content_style_margin',

				[

					'label'      => __( 'Margin', 'elementpress' ),

					'type'       => Controls_Manager::DIMENSIONS,

					'size_units' => [ 'px' ],

					'selectors'  => [

						'{{WRAPPER}} .elementpress-grid-container .elementpress-post .elementpress-post-grid-excerpt ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

					],

				]

			);

			$this->add_responsive_control(

				'elementpressd_grid_content_style_padding',

				[

					'label'      => __( 'Padding', 'elementpress' ),

					'type'       => Controls_Manager::DIMENSIONS,

					'size_units' => [ 'px', '%' ],

					'selectors'  => [

						'{{WRAPPER}} .elementpress-post-grid-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',

					],

				]

			);

			$this->end_controls_section();

		}

		private function style_not_found_options() {

			// Tab.

			$this->start_controls_section(

				'section_grid_not_found_style',

				[

					'label'     => __( 'Not Found', 'elementpress' ),

					'tab'       => Controls_Manager::TAB_STYLE,

				]

			);

			// Title typography.

			$this->add_group_control(

				\Elementor\Group_Control_Typography::get_type(),

				[

					'name'     => 'elementpressd_grid_not_found_style_typography',

					'scheme'   => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,

					'selector' => '{{WRAPPER}} p.not_found'

				]

			);

			// Title color.

			$this->add_control(

				'elementpressd_grid_not_found_style_color',

				[

					'type'      => Controls_Manager::COLOR,

					'label'     => __( 'Color', 'elementpress' ),

					'scheme'    => [

						'type'  => \Elementor\Core\Schemes\Color::get_type(),

						'value' => \Elementor\Core\Schemes\Color::COLOR_1,

					],				

					'selectors' => [

						'{{WRAPPER}} p.not_found'=> 'color: {{VALUE}};',					

					],

				]

			);

			// Title margin.

			$this->add_responsive_control(

				'elementpressd_grid_not_found_style_margin',

				[

					'label'      => __( 'Margin', 'elementpress' ),

					'type'       => Controls_Manager::DIMENSIONS,

					'size_units' => [ 'px' ],

					'selectors'  => [

						'{{WRAPPER}} p.not_found ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

					],

				]

			);

			$this->end_controls_section();

		}

		private function style_readmore_options() {

			// Tab.

			$this->start_controls_section(

				'section_grid_readmore_style',

				[

					'label' => __( 'Read More', 'elementpress' ),

					'tab'   => Controls_Manager::TAB_STYLE,

				]

			);

			// Readmore typography.

			$this->add_group_control(

				\Elementor\Group_Control_Typography::get_type(),

				[

					'name'      => 'elementpressd_grid_readmore_style_typography',

					'scheme'    => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,

					'selector'  => '{{WRAPPER}} .elementpress-grid-container .elementpress-post a#elementpress-read-more-btn',

				]

			);

			// Readmore color.

			$this->add_control(

				'elementpressd_grid_readmore_style_color',

				[

					'type'      => Controls_Manager::COLOR,

					'label'     => __( 'Color', 'elementpress' ),

					'scheme'    => [

						'type'  => \Elementor\Core\Schemes\Color::get_type(),

						'value' => \Elementor\Core\Schemes\Color::COLOR_1,

					],

					'selectors' => [

						'{{WRAPPER}} .read_more' => 'color: {{VALUE}};',

					],

				]

			);

			$this->add_control(

				'elementpressd_grid_readmore_style_backgroundcolor',

				[

					'type'      => Controls_Manager::COLOR,

					'label'     => __( 'Background Color', 'elementpress' ),

					'scheme'    => [

						'type'  => \Elementor\Core\Schemes\Color::get_type(),

						'value' => \Elementor\Core\Schemes\Color::COLOR_1,

					],

					'selectors' => [

						'{{WRAPPER}} .read_more' => 'background-color: {{VALUE}};',

					],

				]

				);

				$this->add_group_control(

					\Elementor\Group_Control_Border::get_type(),

					[

						'name' => 'border_opt',

						'label' => __( 'Border', 'elementpress' ),

						'selector' => '{{WRAPPER}} .read_more',

					]

				);

	//Hover Properties Read More Button....

	$this->add_control(

		'elementpressd_grid_readmore_style_color_hover',

		[

			'type'      => Controls_Manager::COLOR,

			'label'     => __( 'Hover Color', 'elementpress' ),

			'scheme'    => [

				'type'  => \Elementor\Core\Schemes\Color::get_type(),

				'value' => \Elementor\Core\Schemes\Color::COLOR_1,

			],

			'selectors' => [

				'{{WRAPPER}} .read_more:hover' => 'color: {{VALUE}};',

			],

		]

	);

	$this->add_control(

		'elementpressd_grid_readmore_style_backgroundcolor_hover',

		[

			'type'      => Controls_Manager::COLOR,

			'label'     => __( 'Hover Background Color', 'elementpress' ),

			'scheme'    => [

				'type'  => \Elementor\Core\Schemes\Color::get_type(),

				'value' => \Elementor\Core\Schemes\Color::COLOR_1,

			],

			'selectors' => [

				'{{WRAPPER}} .read_more:hover' => 'background-color: {{VALUE}};',

			],

		]

		);

		$this->add_group_control(

			\Elementor\Group_Control_Border::get_type(),

			[

				'name' => 'border',

				'label' => __( 'Hover Border', 'elementpress' ),

				'selector' => '{{WRAPPER}} .read_more:hover',

			]

		);

				$this->add_control(

					'readmore_border_radius',

					[

						'label' => __( 'Button Border Radius', 'elementpress' ),

						'type' => Controls_Manager::DIMENSIONS,

						'size_units' => [ 'px', '%' ],

						'selectors' => [

							'{{WRAPPER}} .read_more' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

						],

					]

				);

			// Readmore margin

			$this->add_responsive_control(

				'elementpressd_grid_readmore_style_margin',

				[

					'label'      => __( 'Margin', 'elementpress' ),

					'type'       => Controls_Manager::DIMENSIONS,

					'size_units' => [ 'px' ],

					'selectors'  => [

						'{{WRAPPER}} .read_more' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

					],

				]

			);

			$this->add_responsive_control(

				'elementpressd_grid_readmore_style_padding',

				[

					'label'      => __( 'Padding', 'elementpress' ),

					'type'       => Controls_Manager::DIMENSIONS,

					'size_units' => [ 'px' ],

					'selectors'  => [

						'{{WRAPPER}} .read_more' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

					],

				]

			);

			$this->end_controls_section();

		}

		protected function render( $instance = [] ) {

			// Get settings.

			$settings = $this->get_settings();

	?>

	<div class="elementpress-grid">

				<?php 

				$elementpresscolumnsdesktop = ( ! empty( $settings['elementpress_columns'] ) ? 'elementpress-grid-desktop-' . $settings['elementpress_columns'] : 'elementpress-grid-desktop-3' );

				$elementpresscolumnstablet = ( ! empty( $settings['elementpressd_columns_tablet'] ) ? ' elementpress-grid-tablet-' . $settings['elementpressd_columns_tablet'] : 'elementpress-grid-tablet-2' );

				$elementpresscolumnsmobile = ( ! empty( $settings['elementpressd_columns_mobile'] ) ? ' elementpress-grid-mobile-' . $settings['elementpressd_columns_mobile'] : ' elementpress-grid-mobile-1' );

				$elementpressgridstyle = $settings['elementpressd_grid_style'];

				$elementpressgridclass = '';

				if( 5 == $elementpressgridstyle ){

					$elementpressgridclass = 'elementpress-meta-bottom';

				}

				?>

				<div class="elementpress-grid-container elementor-grid <?php echo $elementpresscolumnsdesktop.$elementpresscolumnstablet.$elementpresscolumnsmobile.$elementpressgridclass; ?>">

					<?php

		global $query_string;

		$query_args = explode("&", $query_string);

		$search_query = array();

		foreach($query_args as $key => $string) {

			$query_split = explode("=", $string);

			$search_query[$query_split[0]] = urldecode($query_split[1]);

		  } // foreach

					$all_posts = new \WP_Query($search_query);

					if ( $all_posts->have_posts() ) :

						if( 5 == $elementpressgridstyle ){

							include( __DIR__ . '/layouts/layout-5.php' );

						}elseif( 4 == $elementpressgridstyle ){

							include( __DIR__ . '/layouts/layout-4.php' );

						}elseif( 3 == $elementpressgridstyle ){

							include( __DIR__ . '/layouts/layout-3.php' );

						}elseif( 2 == $elementpressgridstyle ){

							include( __DIR__ . '/layouts/layout-2.php' );

						}else{

							include( __DIR__ . '/layouts/layout-1.php' );

						}

				 else : ?>

						<p class="not_found"><?php _e('Sorry, no posts matched your criteria.' ); ?></p>

					<?php endif; ?>

				</div>			      						               

			</div>

			<?php

		}

protected function render_thumbnail() {	

	$settings = $this->get_settings();

	$elementpressd_show_image = $settings['elementpressd_show_image'];

	if ( 'yes' !== $elementpressd_show_image ) {

		return;

	}

	$elementpressd_post_thumbnail_size = $settings['post_thumbnail_size'];

	if ( has_post_thumbnail() ) :  ?>

		<div class="elementpress-post-grid-thumbnail">

			<a href="<?php the_permalink(); ?>">

				<?php the_post_thumbnail( $elementpressd_post_thumbnail_size ); ?>

			</a>

		</div>

	<?php endif;

}

 protected function render_title() {	

	$settings = $this->get_settings();

	$elementpressd_show_title = $settings['elementpressd_show_title'];

	if ( 'yes' !== $elementpressd_show_title ) {

		return;

	}

	$elementpressd_title_tag = $settings['elementpressd_title_tag'];

	?>

	<<?php echo $elementpressd_title_tag; ?> class="title">

		<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>

	</<?php echo $elementpressd_title_tag; ?>>

	<?php

}

protected function render_meta() {

	$settings = $this->get_settings();

	$elementpressd_meta_data = $settings['elementpressd_meta_data'];

	if ( empty( $elementpressd_meta_data ) ) {

		return;

	}

	?>

	<div class="elementpress-post-grid-meta">

		<?php

		if ( in_array( 'author', $elementpressd_meta_data ) ) { ?>

			<span class="post-author"><?php the_author(); ?></span>

			<?php 

		}

		if ( in_array( 'date', $elementpressd_meta_data ) ) { 

$archive_year  = get_the_time('Y'); 

$archive_month = get_the_time('m'); 

$archive_day   = get_the_time('d'); ?>

			<span class="post-author"><a href="<?php echo get_day_link($archive_year,$archive_month, $archive_day);?>"><?php echo apply_filters( 'the_date', get_the_date(), get_option( 'date_format' ), '', '' ); ?></a></span>

			<?php

		}

		if ( in_array( 'categories', $elementpressd_meta_data ) ) {

			$categories_list = get_the_category_list( esc_html__( ', ', 'elementpressd-addons' ) ); 

			if ( $categories_list ) {

				printf( '<span class="post-categories">%s</span>', $categories_list ); // WPCS: XSS OK.

			}

		}

		if ( in_array( 'comments', $elementpressd_meta_data ) ) { ?>

			<span class="post-comments"><?php comments_number(); ?></span>

			<?php

		}

		?>

	</div>

	<?php

}

protected function render_excerpt() {

	$settings = $this->get_settings();

	$elementpressd_show_excerpt = $settings['elementpressd_show_excerpt'];

	if ( 'yes' !== $elementpressd_show_excerpt ) {

		return;

	}

	$excerpt_length=$settings['elementpressd_excerpt_length'];

	?>

	<div class="elementpress-post-grid-excerpt">

		<?php

		    $excerpt=get_the_content();

			echo wp_trim_words( $excerpt , $excerpt_length ); 

		?>

	</div>

	<?php

}

protected function render_readmore() {

	$settings = $this->get_settings();

	$elementpressd_show_read_more = $settings['elementpressd_show_read_more'];

	if ( 'yes' !== $elementpressd_show_read_more ) {

		return;

	}

	?>

	<a style="display:inline-block" class="read_more" id="elementpress-read-more-btn" href="<?php the_permalink(); ?>"><?=$settings['elementpressd_read_more_text']; ?></a>

	<?php

}

    protected function content_template() { }

}