<?php
namespace Elementor;
use \Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography as Scheme_Typography;

if ( ! defined( 'ABSPATH' ) ) exit;
class Elementpress_Widget_postcontent extends Widget_Base {
	public $base;
    public function get_name() {
		//get name from postcontent-handler file
		return 'elementpress-postcontent';
    }
    public function get_title() {
		//get title from postcontent-handler file
		return esc_html__( 'Post Content', 'elementpress' );
    }
    public function get_icon() {
		//get icon from postcontent-handler file
		return 'eicon-post-content';
    }
    public function get_categories() {
		//get categories from postcontent-handler file
        return [ 'elementpress_singlepost' ];
	}
	//default elementor function to register and build controls
    protected function register_controls() {
		//single post content section
        $this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Single Post Content', 'elementpress' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		//text align control inside single post content section
        $this->add_control(
			'title_align',
			[
				'label' => __( 'Alignment', 'elementpress' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'elementpress' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'elementpress' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'elementpress' ),
						'icon' => 'fa fa-align-right',
					],
					'right' => [
						'title' => __( 'Right', 'elementpress' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'left',
				'selectors' => [
					'{{WRAPPER}} .post_content p' => 'text-align: {{VALUE}};',
				],
				'separator' => 'before',
			]
		);
		$this->end_controls_section(); //end first section
		//style section after single post content section.
        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'Style', 'elementpress' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		//typography control inside style section.
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Typography', 'elementpress' ),
				'scheme' => Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .post_content p', //adding this control to p tag having class .post_content in render function
			]
        );
         //Color picker control inside style section
         $this->add_control(
        	'title_color',
        	[
        		'label' => __( 'Title Color Text', 'elementpress' ),
        		'type' => Controls_Manager::COLOR,
        	'default' => '#000',
        		'selectors' => [
        			'{{WRAPPER}} .post_content p' => 'color: {{VALUE}}', //adding this control to p tag having class .post_content in render function
        		],
        	]
        );
        $this->end_controls_section();
	}
	//front end display
    protected function render() {
		//getting all the settings (control title)of every controls and section.
		$settings = $this->get_settings_for_display();
		$queried_object = get_queried_object();

		if ( $queried_object ) {
			$post_id = $queried_object->ID;
			//	echo $post_id;
		}
		$post = get_post($post_id); // specific post
		$the_content = apply_filters('the_content', $post->post_content);
		if ( !empty($the_content) ) {
			?>
			<div class="post_content">
				<?php echo $the_content; ?>
			</div>
			<?php
		}
		?>

		<?php

	}
    protected function content_template() { }
}