<?php

namespace Elementor;

use \Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography as Scheme_Typography;

if (!defined('ABSPATH')) exit;

class Elementpress_Widget_metapost extends Widget_Base
{
    public $base;

    public function get_name()
    {
        //get widget name from metapost-handler.php file
        return 'elementpress-metapost';
    }

    //get widget title from metapost-handler.php file
    public function get_title()
    {
        return esc_html__('Post Meta', 'elementpress');
    }

    //get widget icon from metapost-handler.php file
    public function get_icon()
    {
        return 'eicon-meta-data';
    }

    //get widget category from metapost-handler.php file
    public function get_categories()
    {
        return ['elementpress_singlepost'];
    }

    //regsiter control
    protected function register_controls()
    {
        //single post meta section
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Single Post Meta', 'elementpress'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        //Respeater control
        $repeater = new \Elementor\Repeater();

        //Meta data select box control
        $repeater->add_control(
            'meta_data',
            [
                'label' => __('Meta Data', 'elementpress'),
                'label_block' => true,
                'type' => Controls_Manager::SELECT,
                'multiple' => true,
                'default' => __('Select Meta', 'elementpress'),
                'options' => [
                    'author' => __('Author', 'elementpress'),
                    'date' => __('Date', 'elementpress'),
                    'categories' => __('Categories', 'elementpress'),
                    'comments' => __('Comments', 'elementpress'),
                    'tags' => __('Tags', 'elementpress'),
                ],
                'separator' => 'before',
            ]
        );
        //icon control choose icon control
        $repeater->add_control(
            'icon',
            [
                'label' => __('Icon', 'elementpress'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
            ]
        );
        //icon margin slider control
        $repeater->add_control(
            'meta_icon_indent',
            [
                'label' => __('Icon Margin', 'elementpress'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} > #ic_space.right-icon' => 'margin-right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        //show icon switcher control
        $repeater->add_control(
            'show_icon',
            [
                'label' => __('Show Icon', 'elementpress'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'elementpress'),
                'label_off' => __('Hide', 'elementpress'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        //Meta margin right slider control
        $repeater->add_control(
            'meta_indent_right',
            [
                'label' => __('Mata Right Margin', 'elementpress'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'margin-right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        //Meta margin left slider control
        $repeater->add_control(
            'meta_indent_left',
            [
                'label' => __('Mata Left Margin', 'elementpress'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'margin-left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        //icon color picker
        $repeater->add_responsive_control(
            'mata_icon_color',
            [
                'label' => esc_html__('Mata Icon Color', 'elementpress'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} > i' => 'color: {{VALUE}};',
                ],
            ]
        );
        //text color picker
        $repeater->add_responsive_control(
            'mata_text_color',
            [
                'label' => esc_html__('Mata Text Color', 'elementpress'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} >a ' => 'color: {{VALUE}};',
                ],
            ]
        );
        //meta text background color picker
        $repeater->add_responsive_control(
            'mata_text_backgroundcolor',
            [
                'label' => esc_html__('Mata Text Background Color', 'elementpress'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} >a ' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        //meta text hover  color  picker
        $repeater->add_responsive_control(
            'mata_text_color_hover',
            [
                'label' => esc_html__('Mata Text Color hover', 'elementpress'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} >a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        //meta text background color hover  (color  picker)
        $repeater->add_responsive_control(
            'mata_text_backgroundcolor_hover',
            [
                'label' => esc_html__('Mata Text Background Color Hover', 'elementpress'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} >a:hover ' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        //Repeater List control
        $this->add_control(
            'meta_list',
            [
                'label' => __('Repeater List', 'elementpress'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'meta_data' => __('Meta', 'elementpress'),
                        'icon' => 'fas fa-star',
                        'meta_icon_indent' => __('Icon Spacing', 'elementpress'),
                        'meta_indent_right' => __('Meta Spacing Right', 'elementpress'),
                        'meta_indent_left' => __('Meta Spacing Left', 'elementpress'),
                        'mata_icon_color' => __('Meta Icon Color', 'elementpress'),
                        'mata_text_color' => __('Meta Text Color', 'elementpress'),
                    ],
                ],
                'title_field' => '{{{ meta_data }}}',
            ]
        );
        //alignment control for meta
        $this->add_control(
            'Mata_align',
            [
                'label' => __('Alignment', 'elementpress'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'elementpress'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'elementpress'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'elementpress'),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .outer' => 'text-align: {{VALUE}};',
                ],
                'separator' => 'before',
            ]
        );
        $this->end_controls_section(); //end single post meta section
        //style section under single post meta section
        $this->start_controls_section(
            'style_section',
            [
                'label' => __('Style', 'elementpress'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        //typography control inside style section
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'meta_typography',
                'label' => __('Meta Typography', 'elementpress'),
                'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} a.postmeta',
            ]
        );
        //marign control inside style section
        $this->add_control(
            'margin',
            [
                'label' => __('Margin Meta ', 'elementpress'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} a.postmeta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        //padding control inside style section
        $this->add_control(
            'padding',
            [
                'label' => __('Padding Meta ', 'elementpress'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} a.postmeta' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} ;',
                ],
            ]
        );
        //border control
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'label' => __('Border', 'elementpress'),
                'selector' => '{{WRAPPER}} a.postmeta',
            ]
        );
        //meta background color hover control (color picker)
        $this->add_responsive_control(
            'mata_bordercolor_hover',
            [
                'label' => esc_html__('Mata Border Color Hover', 'elementpress'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} a.postmeta:hover ' => 'border-color: {{VALUE}};',
                ],
            ]
        );
        //border radius control
        $this->add_control(
            'border_radius',
            [
                'label' => __('Border Radius Meta ', 'elementpress'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} a.postmeta' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} ;',
                ],
            ]
        );
        $this->end_controls_section(); //end style section
    }

    //fron end rendering
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        // if ( $settings['meta_list'] ) {
        // 	echo '<dl>';
        // 	foreach (  $settings['meta_list'] as $item ) {
        // 		echo '<dt class="elementor-repeater-item-' . $item['_id'] . '">' . $item['meta_data'] . '</dt>';
        // 	}
        // 	echo '</dl>';
        // }
        $current_page = sanitize_post($GLOBALS['wp_the_query']->get_queried_object());
        if (isset($current_page) && !empty($current_page)) {
            // Get the page slug
            $slug = $current_page->post_name;
        } else {
            $slug = '';
        }
        $args = array(
            'name' => $slug,
            'post_type' => 'post',
            'post_status' => 'publish',
            'numberposts' => 1
        );
        $my_posts = get_posts($args);
        if (isset($my_posts) && !empty($my_posts)) {
            // Get the page slug
            $post = $my_posts[0];
        } else {
            $post = '';
        }
        ?>
        <div class="outer">
            <?php
            foreach ($settings['meta_list'] as $item) {
                $meta = $item['meta_data'];
                if ($meta == 'author') { ?>
                    <div style="display:inline-block"
                         class="elementor-repeater-item-<?php echo esc_attr($item['_id']); ?>"><?php if ($item['show_icon'] == 'yes') {
                            echo '<i id="ic_space" class="right-icon ' . $item['icon']['value'] . '"></i>';
                        } ?><a class="postmeta" href="<?php echo get_author_posts_url($post->post_author); ?>"
                               style="display:inline-block"><?php the_author_meta('user_nicename', $post->post_author); ?></a>
                    </div>
                    <?php
                }
                if ('date' == $meta) {
                    $archive_year = get_the_time('Y');
                    $archive_month = get_the_time('m');
                    $archive_day = get_the_time('d');
                    ?>
                    <div style="display:inline-block"
                         class="elementor-repeater-item-<?php echo esc_attr($item['_id']); ?>"><?php if ($item['show_icon'] == 'yes') {
                            echo '<i id="ic_space" class="right-icon ' . $item['icon']['value'] . '"></i>';
                        } ?><a class="postmeta"
                               href="<?php echo get_day_link($archive_year, $archive_month, $archive_day); ?>"
                               style="display:inline-block"><?php echo get_post_time(get_option('date_format'), false, $post, true); ?></a>
                    </div>
                    <?php
                }
                if ('categories' == $meta) {

                    if ($post->ID)
                        $category_detail = get_the_category($post->ID);//$post->ID
                    ?>
                    <div style="display:inline-block"
                         class="elementor-repeater-item-<?php echo esc_attr($item['_id']); ?>">
                        <?php if ($item['show_icon'] == 'yes') {
                            echo '<i id="ic_space" class="right-icon ' . $item['icon']['value'] . '"></i>';
                        }

                        foreach ($category_detail as $cd) {

                            //echo '<pre> Cat Name'. print_r($cd).'</pre>';

                            $category_id = get_cat_ID($cd->cat_name); ?>
                            <a class="postmeta" href="<?php echo get_category_link($category_id); ?>"
                               style="display:inline-block"><?= $cd->cat_name ?></a>
                        <?php } ?>
                    </div>
                    <?php
                }
                if ('comments' == $meta) {
                    //$comment_array = get_approved_comments(isset($post->ID));
                    if(get_comments_number($post->ID)){
                    $approvedComments = get_comments_number($post->ID);//count($comment_array);
                    ?>
                    <div style="display:inline-block"
                         class="elementor-repeater-item-<?php echo esc_attr($item['_id']); ?>"><?php if ($item['show_icon'] == 'yes') {
                            echo '<i id="ic_space" class="right-icon ' . $item['icon']['value'] . '"></i>';
                        } ?><a class="postmeta" href="<?php echo get_comments_link(); ?>"
                               style="display:inline-block"><?php echo 'Comments ' . $approvedComments; ?></a></div>
                    <?php
                }
            }
                
                if ('tags' == $meta) {
                    $tags_detail = get_the_tags($post->ID);
                    if (empty($tags_detail)) {
                        break;
                    } else {
                        foreach ($tags_detail as $tg) {
                            if ($tg->name == '') {
                                echo '';
                            } else {
                                ?>
                                <div style="display:inline-block"
                                     class="elementor-repeater-item-<?php echo esc_attr($item['_id']); ?>"><?php if ($item['show_icon'] == 'yes') {
                                        echo '<i id="ic_space" class="right-icon ' . $item['icon']['value'] . '"></i>';
                                    } ?><a class="postmeta" href="<?php echo get_tag_link($tg->term_id); ?>"
                                           style="display:inline-block"><?php echo $tg->name; ?></a></div>
                            <?php }
                        }
                    }
                }
            }
            ?>
        </div>
        <?php
    }

    protected function content_template()
    {
    }
}
