<?php


namespace Elementor;

use \Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography as Scheme_Typography;
Use Elementor\Core\Schemes\Color as Scheme_Color;


if (!defined('ABSPATH')) exit;

class ElementPress_Info_Box extends Widget_Base
{

    public $base;


    public function __construct($data = [], $args = null)
    {

        parent::__construct($data, $args);


        wp_register_style('info-css', \ElementPress::widgets_url() . '/info-box/assets/custom.css', false, \ElementPress::version);


    }


    public function get_style_depends()
    {


        return ['info-css'];

    }

    public function get_name()
    {

        //get name from price-handler file

        return 'elementpress-info-box';

    }

    public function get_title()
    {

        //get title from price-handler file

        return esc_html__('Info Box', 'elementpress');

    }

    public function get_icon()
    {

        //get icon from price-handler file

        return 'eicon-image-box';

    }

    public function get_categories()
    {

        //get category where widget will be added in elementor front end

        return ['additional-addons'];

    }

    // elementor default function to register your controls

    protected function register_controls()
    {

//  Content Section Dual Heading Start

        $this->start_controls_section(

        //section which is shown after you drage your widget in the fornt-end area

            'section_content',

            [

                'label' => __('Info Box', 'additional-addons'),//......

            ]

        );

// add image

        $this->add_control(

            'image',

            [

                'label' => __('Choose Image', 'elementpress'),

                'type' => Controls_Manager::MEDIA,

                'default' => [

                    'url' => Utils::get_placeholder_image_src(),

                ],


            ]

        );


        $this->add_control(

            'custom_dimension',

            [

                'label' => __('Image Dimension', 'elementpress'),

                'type' => Controls_Manager::IMAGE_DIMENSIONS,

                'description' => __('Crop the original image size to any custom size. Set custom width or height to keep the original size ratio.', 'elementpress'),

                'default' => [

                    'width' => '',

                    'height' => '',

                ],

                'selector' => '.custom-class3',

            ]

        );


        $this->add_control(

            'text_align2',

            [

                'label' => __('Image Alignment', 'elementpress'),

                'type' => \Elementor\Controls_Manager::CHOOSE,

                'options' => [

                    'left' => [

                        'title' => __('Left', 'elementpress'),

                        'icon' => 'fa fa-align-left',

                    ],

                    'center' => [

                        'title' => __('Center', 'elementpress'),

                        'icon' => 'fa fa-align-center',

                    ],

                    'right' => [

                        'title' => __('Right', 'elementpress'),

                        'icon' => 'fa fa-align-right',

                    ],

                ],

                'default' => 'center',

                'toggle' => true,

                'selector' => '.custom-class3',

            ]


        );


        $this->add_group_control(

            Group_Control_Background::get_type(),

            [

                'name' => 'background',

                'label' => __('Background', 'elementpress'),

                'types' => ['classic', 'gradient', 'video'],

                'selector' => '{{WRAPPER}} .custom-class3',

            ]

        );


        $this->add_control(

            'image_opacity',

            [

                'label' => __('Opacity', 'elementor'),

                'type' => Controls_Manager::SLIDER,

                'range' => [

                    'px' => [

                        'max' => 1,

                        'min' => 0.10,

                        'step' => 0.01,

                    ],

                ],

                'selectors' => [

                    '.custom-class3:hover' => 'opacity: {{SIZE}};',

                ],

            ]

        );

        // ////////////    Adding text editor //////////////////////////////////////////////


        $this->add_control(

            'item_description',

            [

                'label' => __('Description', 'elementpress'),

                'type' => \Elementor\Controls_Manager::WYSIWYG,

                'default' => __('Default description', 'elementpress'),

                'placeholder' => __('Type your description here', 'elementpress'),

                'selector' => '{{WRAPPER}} .para-typo',

            ]

        );


        $this->add_group_control(

            Group_Control_Typography::get_type(),

            [

                'name' => 'content_typography',

                'label' => __('Typography', 'elementpress'),

                'scheme' => Scheme_Typography::TYPOGRAPHY_1,

                'selector' => '{{WRAPPER}} .para-typo',

            ]

        );


//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


// adding input text field named From.

        $this->add_control(

            'heading',

            [

                'label' => __('Custom Heading', 'elementpress'),

                'type' => Controls_Manager::SELECT,

                'default' => 'h1',

                'options' => [

                    'h1' => __('H1', 'elementpress'),

                    'h2' => __('H2', 'elementpress'),

                    'h3' => __('H3', 'elementpress'),

                    'h4' => __('H4', 'elementpress'),

                    'h5' => __('H5', 'elementpress'),

                    'h6' => __('H6', 'elementpress'),

                ],

            ]

        );

        $this->add_group_control(

            Group_Control_Typography::get_type(),

            [

                'name' => 'heading_content_typography',

                'label' => __('Heading Typography', 'elementpress'),

                'scheme' => Scheme_Typography::TYPOGRAPHY_1,

                'selector' => '{{WRAPPER}} .custom-class',

            ]

        );

        $this->add_control(

            'text_align',

            [

                'label' => __('Heading Alignment', 'elementpress'),

                'type' => Controls_Manager::CHOOSE,

                'options' => [

                    'left' => [

                        'title' => __('Left', 'elementpress'),

                        'icon' => 'fa fa-align-left',

                    ],

                    'center' => [

                        'title' => __('Center', 'elementpress'),

                        'icon' => 'fa fa-align-center',

                    ],

                    'right' => [

                        'title' => __('Right', 'elementpress'),

                        'icon' => 'fa fa-align-right',

                    ],

                ],

                'default' => 'center',

                'toggle' => true,

                'selector' => '.custom-class',

            ]


        );

        $this->add_responsive_control(

            'heading_padding',

            [

                'label' => __('Heading Padding', 'elementpress'),

                'type' => Controls_Manager::DIMENSIONS,

                'size_units' => ['px', 'em', '%'],

                'selectors' => [

                    '{{WRAPPER}} .custom-class' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],

            ]

        );

        $this->add_responsive_control(

            'heading_margin',

            [

                'label' => __('Heading Margin', 'elementpress'),

                'type' => Controls_Manager::DIMENSIONS,

                'size_units' => ['px', 'em', '%'],

                'selectors' => [

                    '{{WRAPPER}} .custom-class' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],

            ]

        );


// adding input text named Price.

        $this->add_control(

            'Text_Area',

            [

                'label' => __('Content ', 'additional-addons'),

                'type' => Controls_Manager::TEXT,

                'default' => __('hello world!', 'additional-addons'),


            ]

        );


        $this->add_control(

            'colors',

            [

                'label' => __('Color', 'elementpress'),

                'type' => Controls_Manager::COLOR,

                'scheme' => [

                    'type' => Scheme_Color::get_type(),

                    'value' => Scheme_Color::COLOR_1,

                ],

                'selectors' => [

                    '.custom-class' => 'color: {{VALUE}}',

                    // '.custom-class1' => 'color: {{VALUE}}',

                ],

            ]

        );


        $this->add_group_control(

            Group_Control_Typography::get_type(),

            [

                'name' => 'content_typography_2',

                'label' => __('Typography', 'elementpress'),

                'scheme' => Scheme_Typography::TYPOGRAPHY_1,

                'selector' => '.custom-class',

            ]

        );


        $this->add_control(

            'show_button',

            [

                'label' => __('Show button', 'elementpress'),

                'type' => \Elementor\Controls_Manager::SWITCHER,

                'label_on' => __('Show', 'elementpress'),

                'label_off' => __('Hide', 'elementpress'),

                'return_value' => 'yes',

                'default' => 'no',


            ]

        );


        $this->add_responsive_control(

            'button_padding',

            [

                'label' => __('Button Padding', 'elementpress'),

                'type' => Controls_Manager::DIMENSIONS,

                'size_units' => ['px', 'em', '%'],

                'selectors' => [

                    '{{WRAPPER}} .overlay-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],

                'condition' => [

                    'show_button' => 'yes'

                ],

            ]

        );

        $this->add_group_control(

            Group_Control_Border::get_type(),

            [

                'name' => 'border',

                'label' => __('Border', 'elementpress'),

                'selector' => '.overlay-btn',

                'condition' => [

                    'show_button' => 'yes'

                ],

            ]

        );

        $this->add_responsive_control(

            'border_radius',

            [

                'label' => esc_html__('Border Radius', 'elementpress'),

                'type' => Controls_Manager::DIMENSIONS,

                'size_units' => ['px'],

                'default' => [

                    'top' => '',

                    'right' => '',

                    'bottom' => '',

                    'left' => '',

                ],

                'selectors' => [

                    '{{WRAPPER}} .overlay-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],

                'condition' => [

                    'show_button' => 'yes'

                ],


            ]

        );

        $this->add_control(

            'title_color',

            [

                'label' => __('Button Color', 'elementpress'),

                'type' => \Elementor\Controls_Manager::COLOR,

                'scheme' => [

                    'type' => \Elementor\Core\Schemes\Color::get_type(),

                    'value' => \Elementor\Core\Schemes\Color::COLOR_1,

                ],

                'selectors' => [

                    '{{WRAPPER}} .overlay-btn' => 'color: {{VALUE}}',

                ],

                'condition' => [

                    'show_button' => 'yes'

                ],

            ]

        );


        $this->add_group_control(

            Group_Control_Typography::get_type(),

            [

                'name' => 'button_content_typography',

                'label' => __('Typography', 'elementpress'),

                'scheme' => Scheme_Typography::TYPOGRAPHY_1,

                'selector' => '.btn-class .overlay-btn',

                'condition' => [

                    'show_button' => 'yes'

                ],

            ]

        );


        $this->add_group_control(

            Group_Control_Background::get_type(),

            [

                'name' => 'button-background-color',

                'label' => __('Background', 'elementpress'),

                'types' => ['classic', 'gradient'],

                'selector' => '{{WRAPPER}} .overlay-btn',

                'condition' => [

                    'show_button' => 'yes'

                ],

            ]

        );


        $this->end_controls_section();

    }

    /**
     * Render the Dual Heading And Dual Button widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */

    //function to show how front end will look like after you change settings in price widget

    //front end live preview.

    protected function render()
    {

        $settings = $this->get_settings_for_display();
//         echo "<pre>";
// echo print_r($settings['image']['alt']);die;

        ?>

        <?php


        //  $listinput=$item['add_input'];


        ?>


        <div class="custom-class3" style="text-align:<?= $settings["text_align2"] ?>"><img alt="<?php echo $settings['image']['alt'] ?>"
                    style="width:<?= $settings['custom_dimension']['width'] ?>px;height:<?= $settings['custom_dimension']['height'] ?>px;"
                    src="<?php echo $settings['image']['url'] ?>">


            <div class='btn-class'>

                <div class="inner-div">

                    <?php

                    if ("yes" === $settings['show_button']) {
                        ?>

                        <div class="para-typo"> <?php echo $settings['item_description']; ?></div>

                        <?php echo "<input type='button' class='overlay-btn' value='Donate'>"; ?>


                    <?php }


                    ?>

                </div>

            </div>

        </div>

        <<?php echo $settings['heading'] ?> class="custom-class" style="color:<?= $settings['colors'] ?>;text-align:<?= $settings['text_align'] ?>">  <?php echo $settings['Text_Area'] . '<br>' ?>  </<?php echo $settings['heading'] ?>>

        <?php

    }


    /**
     * Render the widget output in the editor.
     *
     * Written as a Backbone JavaScript template and used to generate the live preview.
     *
     * @since 1.0.0
     *
     * @access protected
     */

    protected function content_template()
    {

    }

}


