<?php

namespace Elementor;
use \Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography;

if ( ! defined( 'ABSPATH' ) ) exit;

class Elementpress_Widget_callofaction extends Widget_Base {

	public $base;

    public function get_name() {

		return 'elementpress-callofaction';

    }

    public function get_title() {

		return esc_html__( 'Call Of Action', 'elementpress' );

    }

    public function get_icon() {

        return 'eicon-call-to-action';

    }

    public function get_categories() {

		return [ 'elementpress_singlepost' ];

    }

    protected function register_controls() {


        $this->start_controls_section(

			'content_section',

			[

				'label' => __( 'Single Post Call Of Action', 'elementpress' ),

				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,

			]

        );

		$this->add_control(

			'title_epress',

			[

				'label' => __( 'Title', 'elementpress' ),

				'type' => \Elementor\Controls_Manager::TEXT,

				'default' => __( 'Default title', 'elementpress' ),

				'placeholder' => __( 'Type your title here', 'elementpress' ),

			]

		);

		$this->add_control(

			'btn_txt',

			[

				'label' => __( 'Button Text', 'elementpress' ),

				'type' => \Elementor\Controls_Manager::TEXT,

				'default' => __( 'Click Me!', 'elementpress' ),

				'placeholder' => __( 'Type your Text here', 'elementpress' ),

			]

		);

		$this->add_control(

			'html_tags',

			[

				'label' => __( 'Html Tags', 'elementpress' ),

				'type' => \Elementor\Controls_Manager::SELECT,

				'default' => 'h1',

				'options' => [

					'h1'  => __( 'H1', 'elementpress' ),

					'h2' => __( 'H2', 'elementpress' ),

					'h3' => __( 'H3', 'elementpress' ),

					'h4' => __( 'H4', 'elementpress' ),

                    'h5' => __( 'H5', 'elementpress' ),

                    'h6' => __( 'H6', 'elementpress' ),

				],

			]

		);

		$this->add_control(

			'content_epress',

			[

				'label' => __( 'Content', 'elementpress' ),

				'type' => \Elementor\Controls_Manager::WYSIWYG,

				'default' => __( 'Content', 'elementpress' ),

			]

		);

        $this->add_control(

			'title_align',

			[

				'label' => __( 'Alignment', 'elementpress' ),

				'type' => \Elementor\Controls_Manager::CHOOSE,

				'options' => [

					'left' => [

						'title' => __( 'Left', 'elementpress' ),

						'icon' => 'fa fa-align-left',

					],

					'center' => [

						'title' => __( 'Center', 'elementpress' ),

						'icon' => 'fa fa-align-center',

					],

					'right' => [

						'title' => __( 'Right', 'elementpress' ),

						'icon' => 'fa fa-align-right',

					],

				],

				'default' => 'left',

				'selectors' => [

					'{{WRAPPER}} .outer-epress' => 'text-align: {{VALUE}};',

				],

				'separator' => 'before',

			]

		);

        $this->end_controls_section();

        $this->start_controls_section(

			'style_section',

			[

				'label' => __( 'Style', 'elementpress' ),

				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,

			]

        );

        $this->add_group_control(

			Group_Control_Typography::get_type(),

			[

				'name' => 'title_typography',

				'label' => __( 'Title Typography', 'elementpress' ),

				'scheme' => \Elementor\Core\Schemes\Typography ::TYPOGRAPHY_1,

				'selector' => '{{WRAPPER}} .title a',

			]

        );

         //Heading 1 Text Color Change

         $this->add_control(

        	'title_color',

        	[

        		'label' => __( 'Title Color Text', 'elementpress' ),

        		'type' => \Elementor\Controls_Manager::COLOR,

        		'scheme' => [

        			'type' => \Elementor\Core\Schemes\Color::get_type(),

        			'value' => \Elementor\Core\Schemes\Color::COLOR_3,

        		],

        		'default' =>  \Elementor\Core\Schemes\Color::COLOR_3,

        		'selectors' => [

        			'{{WRAPPER}} .title a' => 'color: {{VALUE}}',

        		],

        	]

		);

		$this->add_group_control(

			Group_Control_Typography::get_type(),

			[

				'name' => 'content_typography',

				'label' => __( 'Content Typography', 'elementpress' ),

				'scheme' => \Elementor\Core\Schemes\Typography ::TYPOGRAPHY_1,

				'selector' => '{{WRAPPER}} .content-epress ',

			]

        );

         //Heading 1 Text Color Change

         $this->add_control(

        	'content_color',

        	[

        		'label' => __( 'Content Color Text', 'elementpress' ),

        		'type' => \Elementor\Controls_Manager::COLOR,

        		'scheme' => [

        			'type' => \Elementor\Core\Schemes\Color::get_type(),

        			'value' => \Elementor\Core\Schemes\Color::COLOR_3,

        		],

        		'default' =>  \Elementor\Core\Schemes\Color::COLOR_3,

        		'selectors' => [

        			'{{WRAPPER}} .content-epress' => 'color: {{VALUE}}',

        		],

        	]

		);

		//Heading 1 Text Color Change

		$this->add_control(

        	'text_field_color',

        	[

        		'label' => __( 'Text Field Color Text', 'elementpress' ),

        		'type' => \Elementor\Controls_Manager::COLOR,

        		'scheme' => [

        			'type' => \Elementor\Core\Schemes\Color::get_type(),

        			'value' => \Elementor\Core\Schemes\Color::COLOR_3,

        		],

        		'default' =>  \Elementor\Core\Schemes\Color::COLOR_3,

        		'selectors' => [

        			'{{WRAPPER}} .email-epress' => 'color: {{VALUE}}',

        		],

        	]

		);

		$this->add_control(

        	'text_field_placeholder_color',

        	[

        		'label' => __( 'Text Field PlaceHolder Color Text', 'elementpress' ),

        		'type' => \Elementor\Controls_Manager::COLOR,

        		'scheme' => [

        			'type' => \Elementor\Core\Schemes\Color::get_type(),

        			'value' => \Elementor\Core\Schemes\Color::COLOR_3,

        		],

        		'default' =>  \Elementor\Core\Schemes\Color::COLOR_3,

        		'selectors' => [

        			'{{WRAPPER}} .email-epress::-webkit-input-placeholder' => 'color: {{VALUE}}',

        		],

        	]

		);

		$this->add_control(

        	'text_background_color',

        	[

        		'label' => __( 'Text Box Background Color', 'elementpress' ),

        		'type' => \Elementor\Controls_Manager::COLOR,

        		'scheme' => [

        			'type' => \Elementor\Core\Schemes\Color::get_type(),

        			'value' => \Elementor\Core\Schemes\Color::COLOR_3,

        		],

        		'default' =>  \Elementor\Core\Schemes\Color::COLOR_3,

        		'selectors' => [

        			'{{WRAPPER}} .email-epress' => 'background-color: {{VALUE}}',

        		],

        	]

		);

		$this->add_control(

        	'button_color',

        	[

        		'label' => __( 'Button Color', 'elementpress' ),

        		'type' => \Elementor\Controls_Manager::COLOR,

        		'scheme' => [

        			'type' => \Elementor\Core\Schemes\Color::get_type(),

        			'value' => \Elementor\Core\Schemes\Color::COLOR_3,

        		],

        		'default' =>  \Elementor\Core\Schemes\Color::COLOR_3,

        		'selectors' => [

        			'{{WRAPPER}} .button-epress' => 'background-color: {{VALUE}}',

        		],

        	]

		);

		$this->add_control(

        	'button_hover_color',

        	[

        		'label' => __( 'Button Hover Color', 'elementpress' ),

        		'type' => \Elementor\Controls_Manager::COLOR,

        		'scheme' => [

        			'type' => \Elementor\Core\Schemes\Color::get_type(),

        			'value' => \Elementor\Core\Schemes\Color::COLOR_3,

        		],

        		'default' =>  \Elementor\Core\Schemes\Color::COLOR_3,

        		'selectors' => [

        			'{{WRAPPER}} .button-epress:hover' => 'background-color: {{VALUE}}',

        		],

        	]

		);

		$this->add_control(

        	'button_text_color',

        	[

        		'label' => __( 'Button Text Color', 'elementpress' ),

        		'type' => \Elementor\Controls_Manager::COLOR,

        		'scheme' => [

        			'type' => \Elementor\Core\Schemes\Color::get_type(),

        			'value' => \Elementor\Core\Schemes\Color::COLOR_3,

        		],

        		'default' =>  \Elementor\Core\Schemes\Color::COLOR_3,

        		'selectors' => [

        			'{{WRAPPER}} .button-epress' => 'color: {{VALUE}}',

        		],

        	]

		);

		$this->add_control(

        	'button_text_hover_color',

        	[

        		'label' => __( 'Button Text Hover Color', 'elementpress' ),

        		'type' => \Elementor\Controls_Manager::COLOR,

        		'scheme' => [

        			'type' => \Elementor\Core\Schemes\Color::get_type(),

        			'value' => \Elementor\Core\Schemes\Color::COLOR_3,

        		],

        		'default' =>  \Elementor\Core\Schemes\Color::COLOR_3,

        		'selectors' => [

        			'{{WRAPPER}} .button-epress:hover' => 'color: {{VALUE}}',

        		],

        	]

		);

		$this->add_group_control(

			Group_Control_Typography::get_type(),

			[

				'name' => 'button_typography',

				'label' => __( 'Button Typography', 'elementpress' ),

				'scheme' => \Elementor\Core\Schemes\Typography ::TYPOGRAPHY_1,

				'selector' => '{{WRAPPER}} .button-epress',

			]

		);

		$this->add_group_control(

        Group_Control_Border::get_type(),

        	[

        		'name' => 'border',

        		'label' => __( 'Button Border', 'elementpress' ),

        		'selector' => '{{WRAPPER}} .button-epress',

        	]

        );

		$this->add_responsive_control(

			'button_padding',

			[

				'label' => __( 'Button Paddiing', 'plugin-name' ),

				'type' => \Elementor\Controls_Manager::DIMENSIONS,

				'size_units' => [ 'px', 'em', '%' ],

				'selectors' => [

					'{{WRAPPER}} .button-epress' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

				],

			]

		); 

		$this->add_responsive_control(

			'button_margin',

			[

				'label' => __( 'Button Margin', 'plugin-name' ),

				'type' => \Elementor\Controls_Manager::DIMENSIONS,

				'size_units' => [ 'px', 'em', '%' ],

				'selectors' => [

					'{{WRAPPER}} .button-epress' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

				],

			]

		);

		$this->add_responsive_control(

			'border_radius',

			[

				'label' => __( 'Button Border Radius', 'plugin-name' ),

				'type' => \Elementor\Controls_Manager::DIMENSIONS,

				'size_units' => [ 'px', 'em', '%' ],

				'selectors' => [

					'{{WRAPPER}} .button-epress' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

				],

			]

		);

		$this->add_responsive_control(

			'text_border_radius',

			[

				'label' => __( 'Text Box Border Radius', 'plugin-name' ),

				'type' => \Elementor\Controls_Manager::DIMENSIONS,

				'size_units' => [ 'px', 'em', '%' ],

				'selectors' => [

					'{{WRAPPER}} .email-epress' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

				],

			]

		);

        $this->end_controls_section();

    }

    protected function render() {

		$settings = $this->get_settings_for_display();

	   ?>

	   <div class="outer-epress">

		<div class="title">

		<<?=$settings['html_tags']?>><a><?=$settings['title_epress']?></a></<?=$settings['html_tags']?>>

		</div>

		<div class="content-epress">

		<?=$settings['content_epress']?>

		</div>

		<input class="email-epress" type="text" name="email" placeholder="Email">

		<input class="button-epress" type="button" value="<?=$settings['btn_txt']?>" style="width:100%">

		</div>

<?php 

}

    protected function content_template() { }

}